@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Results for schema comparison between the source and target
 * @property schemaDifferences List of schema differences between the source and target databases
 * @property sourceDatabaseObjectCount Count of source database objects
 * @property targetDatabaseObjectCount Count of target database objects
 * @property validationErrors List of errors that happened while performing schema compare validation
 */
public data class SchemaComparisonValidationResultResponse(
    public val schemaDifferences: SchemaComparisonValidationResultTypeResponse? = null,
    public val sourceDatabaseObjectCount: Map<String, Double>? = null,
    public val targetDatabaseObjectCount: Map<String, Double>? = null,
    public val validationErrors: ValidationErrorResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.SchemaComparisonValidationResultResponse): SchemaComparisonValidationResultResponse = SchemaComparisonValidationResultResponse(
            schemaDifferences = javaType.schemaDifferences().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.SchemaComparisonValidationResultTypeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sourceDatabaseObjectCount = javaType.sourceDatabaseObjectCount().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            targetDatabaseObjectCount = javaType.targetDatabaseObjectCount().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            validationErrors = javaType.validationErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.ValidationErrorResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
