@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Description about the errors happen while performing migration validation
 * @property objectName Name of the object that has the difference
 * @property objectType Type of the object that has the difference. e.g (Table/View/StoredProcedure)
 * @property updateAction Update action type with respect to target
 */
public data class SchemaComparisonValidationResultTypeResponse(
    public val objectName: String? = null,
    public val objectType: String? = null,
    public val updateAction: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.SchemaComparisonValidationResultTypeResponse): SchemaComparisonValidationResultTypeResponse = SchemaComparisonValidationResultTypeResponse(
            objectName = javaType.objectName().map({ args0 -> args0 }).orElse(null),
            objectType = javaType.objectType().map({ args0 -> args0 }).orElse(null),
            updateAction = javaType.updateAction().map({ args0 -> args0 }).orElse(null),
        )
    }
}
