@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Info for certificate to be exported for TDE enabled databases.
 * @property certificateName Name of certificate to be exported.
 * @property password Password to use for encrypting the exported certificate.
 */
public data class SelectedCertificateInputResponse(
    public val certificateName: String,
    public val password: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.SelectedCertificateInputResponse): SelectedCertificateInputResponse = SelectedCertificateInputResponse(
            certificateName = javaType.certificateName(),
            password = javaType.password(),
        )
    }
}
