@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Server properties for MySQL type source
 * @property serverDatabaseCount Number of databases in the server
 * @property serverEdition Edition of the database server
 * @property serverName Name of the server
 * @property serverOperatingSystemVersion Version of the operating system
 * @property serverPlatform Name of the server platform
 * @property serverVersion Version of the database server
 */
public data class ServerPropertiesResponse(
    public val serverDatabaseCount: Int,
    public val serverEdition: String,
    public val serverName: String,
    public val serverOperatingSystemVersion: String,
    public val serverPlatform: String,
    public val serverVersion: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ServerPropertiesResponse): ServerPropertiesResponse = ServerPropertiesResponse(
            serverDatabaseCount = javaType.serverDatabaseCount(),
            serverEdition = javaType.serverEdition(),
            serverName = javaType.serverName(),
            serverOperatingSystemVersion = javaType.serverOperatingSystemVersion(),
            serverPlatform = javaType.serverPlatform(),
            serverVersion = javaType.serverVersion(),
        )
    }
}
