@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Detailed status of current Sql Db migration.
 * @property listOfCopyProgressDetails Details on progress of ADF copy activities.
 * @property migrationState Current State of Migration.
 * @property sqlDataCopyErrors Sql Data Copy errors, if any.
 */
public data class SqlDbMigrationStatusDetailsResponse(
    public val listOfCopyProgressDetails: List<CopyProgressDetailsResponse>,
    public val migrationState: String,
    public val sqlDataCopyErrors: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.SqlDbMigrationStatusDetailsResponse): SqlDbMigrationStatusDetailsResponse = SqlDbMigrationStatusDetailsResponse(
            listOfCopyProgressDetails = javaType.listOfCopyProgressDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.CopyProgressDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            migrationState = javaType.migrationState(),
            sqlDataCopyErrors = javaType.sqlDataCopyErrors().map({ args0 -> args0 }),
        )
    }
}
