@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Server role migration result
 * @property exceptionsAndWarnings Migration exceptions and warnings.
 * @property name Name of server role.
 * @property state Current state of migration
 */
public data class StartMigrationScenarioServerRoleResultResponse(
    public val exceptionsAndWarnings: List<ReportableExceptionResponse>,
    public val name: String,
    public val state: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.StartMigrationScenarioServerRoleResultResponse): StartMigrationScenarioServerRoleResultResponse =
            StartMigrationScenarioServerRoleResultResponse(
                exceptionsAndWarnings = javaType.exceptionsAndWarnings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.ReportableExceptionResponse.Companion.toKotlin(args0)
                    })
                }),
                name = javaType.name(),
                state = javaType.state(),
            )
    }
}
