@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Input for task that validates migration input for SQL to Azure SQL Managed Instance
 * @property backupBlobShare SAS URI of Azure Storage Account Container to be used for storing backup files.
 * @property backupFileShare Backup file share information for all selected databases.
 * @property backupMode Backup Mode to specify whether to use existing backup or create new backup.
 * @property selectedDatabases Databases to migrate
 * @property selectedLogins Logins to migrate
 * @property sourceConnectionInfo Information for connecting to source
 * @property targetConnectionInfo Information for connecting to target
 */
public data class ValidateMigrationInputSqlServerSqlMITaskInputResponse(
    public val backupBlobShare: BlobShareResponse,
    public val backupFileShare: FileShareResponse? = null,
    public val backupMode: String? = null,
    public val selectedDatabases: List<MigrateSqlServerSqlMIDatabaseInputResponse>,
    public val selectedLogins: List<String>? = null,
    public val sourceConnectionInfo: SqlConnectionInfoResponse,
    public val targetConnectionInfo: SqlConnectionInfoResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ValidateMigrationInputSqlServerSqlMITaskInputResponse): ValidateMigrationInputSqlServerSqlMITaskInputResponse =
            ValidateMigrationInputSqlServerSqlMITaskInputResponse(
                backupBlobShare = javaType.backupBlobShare().let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.BlobShareResponse.Companion.toKotlin(args0)
                }),
                backupFileShare = javaType.backupFileShare().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.FileShareResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                backupMode = javaType.backupMode().map({ args0 -> args0 }).orElse(null),
                selectedDatabases = javaType.selectedDatabases().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.MigrateSqlServerSqlMIDatabaseInputResponse.Companion.toKotlin(args0)
                    })
                }),
                selectedLogins = javaType.selectedLogins().map({ args0 -> args0 }),
                sourceConnectionInfo = javaType.sourceConnectionInfo().let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.SqlConnectionInfoResponse.Companion.toKotlin(args0)
                }),
                targetConnectionInfo = javaType.targetConnectionInfo().let({ args0 ->
                    com.pulumi.azurenative.datamigration.kotlin.outputs.SqlConnectionInfoResponse.Companion.toKotlin(args0)
                }),
            )
    }
}
