@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Output for task that validates migration input for SQL to Azure SQL Managed Instance migrations
 * @property backupFolderErrors Errors associated with the BackupFolder path
 * @property backupShareCredentialsErrors Errors associated with backup share user name and password credentials
 * @property backupStorageAccountErrors Errors associated with the storage account provided.
 * @property databaseBackupInfo Information about backup files when existing backup mode is used.
 * @property existingBackupErrors Errors associated with existing backup files.
 * @property id Result identifier
 * @property name Name of database
 * @property restoreDatabaseNameErrors Errors associated with the RestoreDatabaseName
 */
public data class ValidateMigrationInputSqlServerSqlMITaskOutputResponse(
    public val backupFolderErrors: List<ReportableExceptionResponse>,
    public val backupShareCredentialsErrors: List<ReportableExceptionResponse>,
    public val backupStorageAccountErrors: List<ReportableExceptionResponse>,
    public val databaseBackupInfo: DatabaseBackupInfoResponse? = null,
    public val existingBackupErrors: List<ReportableExceptionResponse>,
    public val id: String,
    public val name: String,
    public val restoreDatabaseNameErrors: List<ReportableExceptionResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ValidateMigrationInputSqlServerSqlMITaskOutputResponse): ValidateMigrationInputSqlServerSqlMITaskOutputResponse =
            ValidateMigrationInputSqlServerSqlMITaskOutputResponse(
                backupFolderErrors = javaType.backupFolderErrors().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.ReportableExceptionResponse.Companion.toKotlin(args0)
                    })
                }),
                backupShareCredentialsErrors = javaType.backupShareCredentialsErrors().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.ReportableExceptionResponse.Companion.toKotlin(args0)
                    })
                }),
                backupStorageAccountErrors = javaType.backupStorageAccountErrors().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.ReportableExceptionResponse.Companion.toKotlin(args0)
                    })
                }),
                databaseBackupInfo = javaType.databaseBackupInfo().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.DatabaseBackupInfoResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                existingBackupErrors = javaType.existingBackupErrors().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.ReportableExceptionResponse.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                name = javaType.name(),
                restoreDatabaseNameErrors = javaType.restoreDatabaseNameErrors().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.ReportableExceptionResponse.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
