@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Output for task that validates migration input for Oracle to Azure Database for PostgreSQL for online migrations
 * @property validationErrors Errors associated with a selected database object
 */
public data class ValidateOracleAzureDbPostgreSqlSyncTaskOutputResponse(
    public val validationErrors: List<ReportableExceptionResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datamigration.outputs.ValidateOracleAzureDbPostgreSqlSyncTaskOutputResponse): ValidateOracleAzureDbPostgreSqlSyncTaskOutputResponse =
            ValidateOracleAzureDbPostgreSqlSyncTaskOutputResponse(
                validationErrors = javaType.validationErrors().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datamigration.kotlin.outputs.ReportableExceptionResponse.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
