@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin

import com.pulumi.azurenative.dataprotection.DppResourceGuardProxyArgs.builder
import com.pulumi.azurenative.dataprotection.kotlin.inputs.ResourceGuardProxyBaseArgs
import com.pulumi.azurenative.dataprotection.kotlin.inputs.ResourceGuardProxyBaseArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * ResourceGuardProxyBaseResource object, used for response and request bodies for ResourceGuardProxy APIs
 * Azure REST API version: 2023-01-01.
 * Other available API versions: 2023-04-01-preview, 2023-05-01, 2023-06-01-preview, 2023-08-01-preview, 2023-11-01, 2023-12-01, 2024-02-01-preview, 2024-03-01, 2024-04-01.
 * ## Example Usage
 * ### Create ResourceGuardProxy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dppResourceGuardProxy = new AzureNative.DataProtection.DppResourceGuardProxy("dppResourceGuardProxy", new()
 *     {
 *         Properties = new AzureNative.DataProtection.Inputs.ResourceGuardProxyBaseArgs
 *         {
 *             ResourceGuardResourceId = "/subscriptions/f9e67185-f313-4e79-aa71-6458d429369d/resourceGroups/ResourceGuardSecurityAdminRG/providers/Microsoft.DataProtection/resourceGuards/ResourceGuardTestResource",
 *         },
 *         ResourceGroupName = "SampleResourceGroup",
 *         ResourceGuardProxyName = "swaggerExample",
 *         VaultName = "sampleVault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dataprotection/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dataprotection.NewDppResourceGuardProxy(ctx, "dppResourceGuardProxy", &dataprotection.DppResourceGuardProxyArgs{
 * 			Properties: &dataprotection.ResourceGuardProxyBaseArgs{
 * 				ResourceGuardResourceId: pulumi.String("/subscriptions/f9e67185-f313-4e79-aa71-6458d429369d/resourceGroups/ResourceGuardSecurityAdminRG/providers/Microsoft.DataProtection/resourceGuards/ResourceGuardTestResource"),
 * 			},
 * 			ResourceGroupName:      pulumi.String("SampleResourceGroup"),
 * 			ResourceGuardProxyName: pulumi.String("swaggerExample"),
 * 			VaultName:              pulumi.String("sampleVault"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dataprotection.DppResourceGuardProxy;
 * import com.pulumi.azurenative.dataprotection.DppResourceGuardProxyArgs;
 * import com.pulumi.azurenative.dataprotection.inputs.ResourceGuardProxyBaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dppResourceGuardProxy = new DppResourceGuardProxy("dppResourceGuardProxy", DppResourceGuardProxyArgs.builder()
 *             .properties(ResourceGuardProxyBaseArgs.builder()
 *                 .resourceGuardResourceId("/subscriptions/f9e67185-f313-4e79-aa71-6458d429369d/resourceGroups/ResourceGuardSecurityAdminRG/providers/Microsoft.DataProtection/resourceGuards/ResourceGuardTestResource")
 *                 .build())
 *             .resourceGroupName("SampleResourceGroup")
 *             .resourceGuardProxyName("swaggerExample")
 *             .vaultName("sampleVault")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dataprotection:DppResourceGuardProxy swaggerExample /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/backupVaults/{vaultName}/backupResourceGuardProxies/{resourceGuardProxyName}
 * ```
 * @property properties ResourceGuardProxyBaseResource properties
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceGuardProxyName name of the resource guard proxy
 * @property vaultName The name of the backup vault.
 */
public data class DppResourceGuardProxyArgs(
    public val properties: Output<ResourceGuardProxyBaseArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceGuardProxyName: Output<String>? = null,
    public val vaultName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.DppResourceGuardProxyArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.DppResourceGuardProxyArgs =
        com.pulumi.azurenative.dataprotection.DppResourceGuardProxyArgs.builder()
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceGuardProxyName(resourceGuardProxyName?.applyValue({ args0 -> args0 }))
            .vaultName(vaultName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DppResourceGuardProxyArgs].
 */
@PulumiTagMarker
public class DppResourceGuardProxyArgsBuilder internal constructor() {
    private var properties: Output<ResourceGuardProxyBaseArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceGuardProxyName: Output<String>? = null

    private var vaultName: Output<String>? = null

    /**
     * @param value ResourceGuardProxyBaseResource properties
     */
    @JvmName("tsndurcgewsqaqqj")
    public suspend fun properties(`value`: Output<ResourceGuardProxyBaseArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ionmvycdoqoscwrh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value name of the resource guard proxy
     */
    @JvmName("uglimewhdjhqbvvb")
    public suspend fun resourceGuardProxyName(`value`: Output<String>) {
        this.resourceGuardProxyName = value
    }

    /**
     * @param value The name of the backup vault.
     */
    @JvmName("ugjwbyyinrsyrwal")
    public suspend fun vaultName(`value`: Output<String>) {
        this.vaultName = value
    }

    /**
     * @param value ResourceGuardProxyBaseResource properties
     */
    @JvmName("vjsahggihwrtqvmv")
    public suspend fun properties(`value`: ResourceGuardProxyBaseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument ResourceGuardProxyBaseResource properties
     */
    @JvmName("gffhaxhaymfptfdj")
    public suspend fun properties(argument: suspend ResourceGuardProxyBaseArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceGuardProxyBaseArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("snhnakwpegcftjbj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value name of the resource guard proxy
     */
    @JvmName("grrloxutsooqovdk")
    public suspend fun resourceGuardProxyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGuardProxyName = mapped
    }

    /**
     * @param value The name of the backup vault.
     */
    @JvmName("lqqdfqvbnsrqomuo")
    public suspend fun vaultName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultName = mapped
    }

    internal fun build(): DppResourceGuardProxyArgs = DppResourceGuardProxyArgs(
        properties = properties,
        resourceGroupName = resourceGroupName,
        resourceGuardProxyName = resourceGuardProxyName,
        vaultName = vaultName,
    )
}
