@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin

import com.pulumi.azurenative.dataprotection.ResourceGuardArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2023-01-01. Prior API version in Azure Native 1.x: 2021-10-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-04-01-preview, 2023-05-01, 2023-06-01-preview, 2023-08-01-preview, 2023-11-01, 2023-12-01, 2024-02-01-preview, 2024-03-01, 2024-04-01.
 * ## Example Usage
 * ### Create ResourceGuard
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var resourceGuard = new AzureNative.DataProtection.ResourceGuard("resourceGuard", new()
 *     {
 *         Location = "WestUS",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ResourceGuardsName = "swaggerExample",
 *         Tags =
 *         {
 *             { "key1", "val1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dataprotection/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dataprotection.NewResourceGuard(ctx, "resourceGuard", &dataprotection.ResourceGuardArgs{
 * 			Location:           pulumi.String("WestUS"),
 * 			ResourceGroupName:  pulumi.String("SampleResourceGroup"),
 * 			ResourceGuardsName: pulumi.String("swaggerExample"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("val1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dataprotection.ResourceGuard;
 * import com.pulumi.azurenative.dataprotection.ResourceGuardArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var resourceGuard = new ResourceGuard("resourceGuard", ResourceGuardArgs.builder()
 *             .location("WestUS")
 *             .resourceGroupName("SampleResourceGroup")
 *             .resourceGuardsName("swaggerExample")
 *             .tags(Map.of("key1", "val1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dataprotection:ResourceGuard VaultGuardTestNew /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}
 * ```
 * @property eTag Optional ETag.
 * @property location Resource location.
 * @property properties ResourceGuardResource properties
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceGuardsName The name of ResourceGuard
 * @property tags Resource tags.
 */
public data class ResourceGuardArgs(
    public val eTag: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<com.pulumi.azurenative.dataprotection.kotlin.inputs.ResourceGuardArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceGuardsName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.ResourceGuardArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.ResourceGuardArgs =
        com.pulumi.azurenative.dataprotection.ResourceGuardArgs.builder()
            .eTag(eTag?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceGuardsName(resourceGuardsName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ResourceGuardArgs].
 */
@PulumiTagMarker
public class ResourceGuardArgsBuilder internal constructor() {
    private var eTag: Output<String>? = null

    private var location: Output<String>? = null

    private var properties:
        Output<com.pulumi.azurenative.dataprotection.kotlin.inputs.ResourceGuardArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceGuardsName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Optional ETag.
     */
    @JvmName("ffxqeymgvlddxymn")
    public suspend fun eTag(`value`: Output<String>) {
        this.eTag = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("lhbwlknpnyvyfygu")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value ResourceGuardResource properties
     */
    @JvmName("qdvidcndrmmnhovd")
    public suspend fun properties(`value`: Output<com.pulumi.azurenative.dataprotection.kotlin.inputs.ResourceGuardArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gwmwrvgxvcekqcmq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of ResourceGuard
     */
    @JvmName("vyhrwihluuiqvbgp")
    public suspend fun resourceGuardsName(`value`: Output<String>) {
        this.resourceGuardsName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ottguvcadnqvdwbn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Optional ETag.
     */
    @JvmName("pyoptjmiymxlvljj")
    public suspend fun eTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eTag = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("vifaymorkbxdukcs")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value ResourceGuardResource properties
     */
    @JvmName("tfnnjfcgnjlekgnd")
    public suspend fun properties(`value`: com.pulumi.azurenative.dataprotection.kotlin.inputs.ResourceGuardArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument ResourceGuardResource properties
     */
    @JvmName("gipuakjcptuvkppb")
    public suspend fun properties(argument: suspend com.pulumi.azurenative.dataprotection.kotlin.inputs.ResourceGuardArgsBuilder.() -> Unit) {
        val toBeMapped =
            com.pulumi.azurenative.dataprotection.kotlin.inputs.ResourceGuardArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("chipoxgjnwnhviol")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of ResourceGuard
     */
    @JvmName("mgkcvukyqyilsmwq")
    public suspend fun resourceGuardsName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGuardsName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wkelcqaupcdkfsec")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("tyufiqecdimoljcg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ResourceGuardArgs = ResourceGuardArgs(
        eTag = eTag,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        resourceGuardsName = resourceGuardsName,
        tags = tags,
    )
}
