@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the type of validation. In case of DeepValidation, all validations from /validateForBackup API will run again.
 */
public enum class ValidationType(
    public val javaValue: com.pulumi.azurenative.dataprotection.enums.ValidationType,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.enums.ValidationType> {
    ShallowValidation(com.pulumi.azurenative.dataprotection.enums.ValidationType.ShallowValidation),
    DeepValidation(com.pulumi.azurenative.dataprotection.enums.ValidationType.DeepValidation),
    ;

    override fun toJava(): com.pulumi.azurenative.dataprotection.enums.ValidationType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.enums.ValidationType): ValidationType = ValidationType.values().first { it.javaValue == javaType }
    }
}
