@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.AzureBackupRuleArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure backup rule
 * @property backupParameters BackupParameters base
 * @property dataStore DataStoreInfo base
 * @property name
 * @property objectType
 * Expected value is 'AzureBackupRule'.
 * @property trigger Trigger context
 */
public data class AzureBackupRuleArgs(
    public val backupParameters: Output<AzureBackupParamsArgs>? = null,
    public val dataStore: Output<DataStoreInfoBaseArgs>,
    public val name: Output<String>,
    public val objectType: Output<String>,
    public val trigger: Output<Either<AdhocBasedTriggerContextArgs, ScheduleBasedTriggerContextArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.AzureBackupRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.AzureBackupRuleArgs =
        com.pulumi.azurenative.dataprotection.inputs.AzureBackupRuleArgs.builder()
            .backupParameters(backupParameters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dataStore(dataStore.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .objectType(objectType.applyValue({ args0 -> args0 }))
            .trigger(
                trigger.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [AzureBackupRuleArgs].
 */
@PulumiTagMarker
public class AzureBackupRuleArgsBuilder internal constructor() {
    private var backupParameters: Output<AzureBackupParamsArgs>? = null

    private var dataStore: Output<DataStoreInfoBaseArgs>? = null

    private var name: Output<String>? = null

    private var objectType: Output<String>? = null

    private var trigger:
        Output<Either<AdhocBasedTriggerContextArgs, ScheduleBasedTriggerContextArgs>>? = null

    /**
     * @param value BackupParameters base
     */
    @JvmName("hbvvlxiepfjawobb")
    public suspend fun backupParameters(`value`: Output<AzureBackupParamsArgs>) {
        this.backupParameters = value
    }

    /**
     * @param value DataStoreInfo base
     */
    @JvmName("voxpfghydjlvylvw")
    public suspend fun dataStore(`value`: Output<DataStoreInfoBaseArgs>) {
        this.dataStore = value
    }

    /**
     * @param value
     */
    @JvmName("sijwhjdmqykqffcb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     * Expected value is 'AzureBackupRule'.
     */
    @JvmName("xthsugblxeevbyrk")
    public suspend fun objectType(`value`: Output<String>) {
        this.objectType = value
    }

    /**
     * @param value Trigger context
     */
    @JvmName("rpvlunvciqkmjfxo")
    public suspend fun trigger(`value`: Output<Either<AdhocBasedTriggerContextArgs, ScheduleBasedTriggerContextArgs>>) {
        this.trigger = value
    }

    /**
     * @param value BackupParameters base
     */
    @JvmName("ltdgrgjuruyoblce")
    public suspend fun backupParameters(`value`: AzureBackupParamsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupParameters = mapped
    }

    /**
     * @param argument BackupParameters base
     */
    @JvmName("paiskidoplungdat")
    public suspend fun backupParameters(argument: suspend AzureBackupParamsArgsBuilder.() -> Unit) {
        val toBeMapped = AzureBackupParamsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.backupParameters = mapped
    }

    /**
     * @param value DataStoreInfo base
     */
    @JvmName("yihkvwasmsmuiiga")
    public suspend fun dataStore(`value`: DataStoreInfoBaseArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataStore = mapped
    }

    /**
     * @param argument DataStoreInfo base
     */
    @JvmName("skxenxgcwhphxyyc")
    public suspend fun dataStore(argument: suspend DataStoreInfoBaseArgsBuilder.() -> Unit) {
        val toBeMapped = DataStoreInfoBaseArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dataStore = mapped
    }

    /**
     * @param value
     */
    @JvmName("immbteseduocqlqe")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     * Expected value is 'AzureBackupRule'.
     */
    @JvmName("wjdicyfkemwjficj")
    public suspend fun objectType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectType = mapped
    }

    /**
     * @param value Trigger context
     */
    @JvmName("pixgddmyjifecmdn")
    public suspend fun trigger(`value`: Either<AdhocBasedTriggerContextArgs, ScheduleBasedTriggerContextArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trigger = mapped
    }

    /**
     * @param value Trigger context
     */
    @JvmName("ggfapesfnfqclxpo")
    public fun trigger(`value`: AdhocBasedTriggerContextArgs) {
        val toBeMapped = Either.ofLeft<
            AdhocBasedTriggerContextArgs,
            ScheduleBasedTriggerContextArgs,
            >(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trigger = mapped
    }

    /**
     * @param value Trigger context
     */
    @JvmName("mfffbxmhkbleqqoe")
    public fun trigger(`value`: ScheduleBasedTriggerContextArgs) {
        val toBeMapped = Either.ofRight<
            AdhocBasedTriggerContextArgs,
            ScheduleBasedTriggerContextArgs,
            >(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trigger = mapped
    }

    internal fun build(): AzureBackupRuleArgs = AzureBackupRuleArgs(
        backupParameters = backupParameters,
        dataStore = dataStore ?: throw PulumiNullFieldException("dataStore"),
        name = name ?: throw PulumiNullFieldException("name"),
        objectType = objectType ?: throw PulumiNullFieldException("objectType"),
        trigger = trigger ?: throw PulumiNullFieldException("trigger"),
    )
}
