@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.AzureMonitorAlertSettingsArgs.builder
import com.pulumi.azurenative.dataprotection.kotlin.enums.AlertsState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Settings for Azure Monitor based alerts
 * @property alertsForAllJobFailures
 */
public data class AzureMonitorAlertSettingsArgs(
    public val alertsForAllJobFailures: Output<Either<String, AlertsState>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.AzureMonitorAlertSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.AzureMonitorAlertSettingsArgs = com.pulumi.azurenative.dataprotection.inputs.AzureMonitorAlertSettingsArgs.builder()
        .alertsForAllJobFailures(
            alertsForAllJobFailures?.applyValue({ args0 ->
                args0.transform({ args0 ->
                    args0
                }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
            }),
        ).build()
}

/**
 * Builder for [AzureMonitorAlertSettingsArgs].
 */
@PulumiTagMarker
public class AzureMonitorAlertSettingsArgsBuilder internal constructor() {
    private var alertsForAllJobFailures: Output<Either<String, AlertsState>>? = null

    /**
     * @param value
     */
    @JvmName("xyvqkdyxrovhkhgx")
    public suspend fun alertsForAllJobFailures(`value`: Output<Either<String, AlertsState>>) {
        this.alertsForAllJobFailures = value
    }

    /**
     * @param value
     */
    @JvmName("ovccnjgcqiogfwyg")
    public suspend fun alertsForAllJobFailures(`value`: Either<String, AlertsState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alertsForAllJobFailures = mapped
    }

    /**
     * @param value
     */
    @JvmName("dfmsaqedplnqbujq")
    public fun alertsForAllJobFailures(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AlertsState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alertsForAllJobFailures = mapped
    }

    /**
     * @param value
     */
    @JvmName("jyhycujinfbfmnkg")
    public fun alertsForAllJobFailures(`value`: AlertsState) {
        val toBeMapped = Either.ofRight<String, AlertsState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alertsForAllJobFailures = mapped
    }

    internal fun build(): AzureMonitorAlertSettingsArgs = AzureMonitorAlertSettingsArgs(
        alertsForAllJobFailures = alertsForAllJobFailures,
    )
}
