@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.AzureOperationalStoreParametersArgs.builder
import com.pulumi.azurenative.dataprotection.kotlin.enums.DataStoreTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Parameters for Operational-Tier DataStore
 * @property dataStoreType type of datastore; Operational/Vault/Archive
 * @property objectType Type of the specific object - used for deserializing
 * Expected value is 'AzureOperationalStoreParameters'.
 * @property resourceGroupId Gets or sets the Snapshot Resource Group Uri.
 */
public data class AzureOperationalStoreParametersArgs(
    public val dataStoreType: Output<Either<String, DataStoreTypes>>,
    public val objectType: Output<String>,
    public val resourceGroupId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.AzureOperationalStoreParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.AzureOperationalStoreParametersArgs =
        com.pulumi.azurenative.dataprotection.inputs.AzureOperationalStoreParametersArgs.builder()
            .dataStoreType(
                dataStoreType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .objectType(objectType.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureOperationalStoreParametersArgs].
 */
@PulumiTagMarker
public class AzureOperationalStoreParametersArgsBuilder internal constructor() {
    private var dataStoreType: Output<Either<String, DataStoreTypes>>? = null

    private var objectType: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    /**
     * @param value type of datastore; Operational/Vault/Archive
     */
    @JvmName("nwosncydprvdfucx")
    public suspend fun dataStoreType(`value`: Output<Either<String, DataStoreTypes>>) {
        this.dataStoreType = value
    }

    /**
     * @param value Type of the specific object - used for deserializing
     * Expected value is 'AzureOperationalStoreParameters'.
     */
    @JvmName("txxiblpicgqdffht")
    public suspend fun objectType(`value`: Output<String>) {
        this.objectType = value
    }

    /**
     * @param value Gets or sets the Snapshot Resource Group Uri.
     */
    @JvmName("ptxcxqsfovkkyegk")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value type of datastore; Operational/Vault/Archive
     */
    @JvmName("jhjhliujtmgimupf")
    public suspend fun dataStoreType(`value`: Either<String, DataStoreTypes>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataStoreType = mapped
    }

    /**
     * @param value type of datastore; Operational/Vault/Archive
     */
    @JvmName("wllliaicbfatqyud")
    public fun dataStoreType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DataStoreTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataStoreType = mapped
    }

    /**
     * @param value type of datastore; Operational/Vault/Archive
     */
    @JvmName("wucolxoidobfilnt")
    public fun dataStoreType(`value`: DataStoreTypes) {
        val toBeMapped = Either.ofRight<String, DataStoreTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataStoreType = mapped
    }

    /**
     * @param value Type of the specific object - used for deserializing
     * Expected value is 'AzureOperationalStoreParameters'.
     */
    @JvmName("xiajsuyrevfhmwba")
    public suspend fun objectType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectType = mapped
    }

    /**
     * @param value Gets or sets the Snapshot Resource Group Uri.
     */
    @JvmName("eascfgypryharcvu")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    internal fun build(): AzureOperationalStoreParametersArgs = AzureOperationalStoreParametersArgs(
        dataStoreType = dataStoreType ?: throw PulumiNullFieldException("dataStoreType"),
        objectType = objectType ?: throw PulumiNullFieldException("objectType"),
        resourceGroupId = resourceGroupId,
    )
}
