@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.GetBackupInstancePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property backupInstanceName The name of the backup instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property vaultName The name of the backup vault.
 */
public data class GetBackupInstancePlainArgs(
    public val backupInstanceName: String,
    public val resourceGroupName: String,
    public val vaultName: String,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.GetBackupInstancePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.GetBackupInstancePlainArgs =
        com.pulumi.azurenative.dataprotection.inputs.GetBackupInstancePlainArgs.builder()
            .backupInstanceName(backupInstanceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vaultName(vaultName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBackupInstancePlainArgs].
 */
@PulumiTagMarker
public class GetBackupInstancePlainArgsBuilder internal constructor() {
    private var backupInstanceName: String? = null

    private var resourceGroupName: String? = null

    private var vaultName: String? = null

    /**
     * @param value The name of the backup instance.
     */
    @JvmName("wdgflrhmollxuypx")
    public suspend fun backupInstanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.backupInstanceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dmkmuhewyvdnsamb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the backup vault.
     */
    @JvmName("twimqioipjnbqnpg")
    public suspend fun vaultName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vaultName = mapped
    }

    internal fun build(): GetBackupInstancePlainArgs = GetBackupInstancePlainArgs(
        backupInstanceName = backupInstanceName ?: throw PulumiNullFieldException("backupInstanceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        vaultName = vaultName ?: throw PulumiNullFieldException("vaultName"),
    )
}
