@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.GetDppResourceGuardProxyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceGuardProxyName name of the resource guard proxy
 * @property vaultName The name of the backup vault.
 */
public data class GetDppResourceGuardProxyPlainArgs(
    public val resourceGroupName: String,
    public val resourceGuardProxyName: String,
    public val vaultName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.GetDppResourceGuardProxyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.GetDppResourceGuardProxyPlainArgs =
        com.pulumi.azurenative.dataprotection.inputs.GetDppResourceGuardProxyPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceGuardProxyName(resourceGuardProxyName.let({ args0 -> args0 }))
            .vaultName(vaultName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDppResourceGuardProxyPlainArgs].
 */
@PulumiTagMarker
public class GetDppResourceGuardProxyPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var resourceGuardProxyName: String? = null

    private var vaultName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mrnnokteujusqesb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value name of the resource guard proxy
     */
    @JvmName("cqqoiucssqfpctmo")
    public suspend fun resourceGuardProxyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGuardProxyName = mapped
    }

    /**
     * @param value The name of the backup vault.
     */
    @JvmName("qmmxfhgheydlyfru")
    public suspend fun vaultName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vaultName = mapped
    }

    internal fun build(): GetDppResourceGuardProxyPlainArgs = GetDppResourceGuardProxyPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceGuardProxyName = resourceGuardProxyName ?: throw
            PulumiNullFieldException("resourceGuardProxyName"),
        vaultName = vaultName ?: throw PulumiNullFieldException("vaultName"),
    )
}
