@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.PolicyParametersArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Parameters in Policy
 * @property backupDatasourceParametersList Gets or sets the Backup Data Source Parameters
 * @property dataStoreParametersList Gets or sets the DataStore Parameters
 */
public data class PolicyParametersArgs(
    public val backupDatasourceParametersList: Output<List<Either<BlobBackupDatasourceParametersArgs, KubernetesClusterBackupDatasourceParametersArgs>>>? =
        null,
    public val dataStoreParametersList: Output<List<AzureOperationalStoreParametersArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.PolicyParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.PolicyParametersArgs =
        com.pulumi.azurenative.dataprotection.inputs.PolicyParametersArgs.builder()
            .backupDatasourceParametersList(
                backupDatasourceParametersList?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0.let({ args0 -> args0.toJava() }) }, { args0 ->
                            args0.let({ args0 -> args0.toJava() })
                        })
                    })
                }),
            )
            .dataStoreParametersList(
                dataStoreParametersList?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [PolicyParametersArgs].
 */
@PulumiTagMarker
public class PolicyParametersArgsBuilder internal constructor() {
    private var backupDatasourceParametersList:
        Output<List<Either<BlobBackupDatasourceParametersArgs, KubernetesClusterBackupDatasourceParametersArgs>>>? =
        null

    private var dataStoreParametersList: Output<List<AzureOperationalStoreParametersArgs>>? = null

    /**
     * @param value Gets or sets the Backup Data Source Parameters
     */
    @JvmName("sgdjupmbiutwpspn")
    public suspend fun backupDatasourceParametersList(`value`: Output<List<Either<BlobBackupDatasourceParametersArgs, KubernetesClusterBackupDatasourceParametersArgs>>>) {
        this.backupDatasourceParametersList = value
    }

    @JvmName("nnoquddicydypdsl")
    public suspend fun backupDatasourceParametersList(vararg values: Output<Either<BlobBackupDatasourceParametersArgs, KubernetesClusterBackupDatasourceParametersArgs>>) {
        this.backupDatasourceParametersList = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the Backup Data Source Parameters
     */
    @JvmName("lrgmkpldkespwiqc")
    public suspend fun backupDatasourceParametersList(values: List<Output<Either<BlobBackupDatasourceParametersArgs, KubernetesClusterBackupDatasourceParametersArgs>>>) {
        this.backupDatasourceParametersList = Output.all(values)
    }

    /**
     * @param value Gets or sets the DataStore Parameters
     */
    @JvmName("tvkysxcadvjakcox")
    public suspend fun dataStoreParametersList(`value`: Output<List<AzureOperationalStoreParametersArgs>>) {
        this.dataStoreParametersList = value
    }

    @JvmName("unotsyrenurmteff")
    public suspend fun dataStoreParametersList(vararg values: Output<AzureOperationalStoreParametersArgs>) {
        this.dataStoreParametersList = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the DataStore Parameters
     */
    @JvmName("nfcjlewoewomhely")
    public suspend fun dataStoreParametersList(values: List<Output<AzureOperationalStoreParametersArgs>>) {
        this.dataStoreParametersList = Output.all(values)
    }

    /**
     * @param value Gets or sets the Backup Data Source Parameters
     */
    @JvmName("pjuuweimdscmsysc")
    public suspend fun backupDatasourceParametersList(`value`: List<Either<BlobBackupDatasourceParametersArgs, KubernetesClusterBackupDatasourceParametersArgs>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupDatasourceParametersList = mapped
    }

    /**
     * @param values Gets or sets the Backup Data Source Parameters
     */
    @JvmName("ouqtpoxdicysrirq")
    public suspend fun backupDatasourceParametersList(vararg values: Either<BlobBackupDatasourceParametersArgs, KubernetesClusterBackupDatasourceParametersArgs>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupDatasourceParametersList = mapped
    }

    /**
     * @param value Gets or sets the DataStore Parameters
     */
    @JvmName("kffbhwushincjvvg")
    public suspend fun dataStoreParametersList(`value`: List<AzureOperationalStoreParametersArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataStoreParametersList = mapped
    }

    /**
     * @param argument Gets or sets the DataStore Parameters
     */
    @JvmName("huqryhsygigwuvbm")
    public suspend fun dataStoreParametersList(argument: List<suspend AzureOperationalStoreParametersArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AzureOperationalStoreParametersArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dataStoreParametersList = mapped
    }

    /**
     * @param argument Gets or sets the DataStore Parameters
     */
    @JvmName("mhcvjbjlrfiowcls")
    public suspend fun dataStoreParametersList(vararg argument: suspend AzureOperationalStoreParametersArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AzureOperationalStoreParametersArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dataStoreParametersList = mapped
    }

    /**
     * @param argument Gets or sets the DataStore Parameters
     */
    @JvmName("paudhaberunximie")
    public suspend fun dataStoreParametersList(argument: suspend AzureOperationalStoreParametersArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AzureOperationalStoreParametersArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.dataStoreParametersList = mapped
    }

    /**
     * @param values Gets or sets the DataStore Parameters
     */
    @JvmName("rlgyvuuqssgplhav")
    public suspend fun dataStoreParametersList(vararg values: AzureOperationalStoreParametersArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataStoreParametersList = mapped
    }

    internal fun build(): PolicyParametersArgs = PolicyParametersArgs(
        backupDatasourceParametersList = backupDatasourceParametersList,
        dataStoreParametersList = dataStoreParametersList,
    )
}
