@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.ResourceGuardProxyBaseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * ResourceGuardProxyBase object, used in ResourceGuardProxyBaseResource
 * @property description
 * @property lastUpdatedTime
 * @property resourceGuardOperationDetails
 * @property resourceGuardResourceId
 */
public data class ResourceGuardProxyBaseArgs(
    public val description: Output<String>? = null,
    public val lastUpdatedTime: Output<String>? = null,
    public val resourceGuardOperationDetails: Output<List<ResourceGuardOperationDetailArgs>>? = null,
    public val resourceGuardResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.ResourceGuardProxyBaseArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.ResourceGuardProxyBaseArgs =
        com.pulumi.azurenative.dataprotection.inputs.ResourceGuardProxyBaseArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .lastUpdatedTime(lastUpdatedTime?.applyValue({ args0 -> args0 }))
            .resourceGuardOperationDetails(
                resourceGuardOperationDetails?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceGuardResourceId(resourceGuardResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceGuardProxyBaseArgs].
 */
@PulumiTagMarker
public class ResourceGuardProxyBaseArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var lastUpdatedTime: Output<String>? = null

    private var resourceGuardOperationDetails: Output<List<ResourceGuardOperationDetailArgs>>? = null

    private var resourceGuardResourceId: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("exxijecroyhwejpa")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value
     */
    @JvmName("ruhgaibuqnvnjvyt")
    public suspend fun lastUpdatedTime(`value`: Output<String>) {
        this.lastUpdatedTime = value
    }

    /**
     * @param value
     */
    @JvmName("rvfhhroubsipgpas")
    public suspend fun resourceGuardOperationDetails(`value`: Output<List<ResourceGuardOperationDetailArgs>>) {
        this.resourceGuardOperationDetails = value
    }

    @JvmName("dwbelvpjuocmmigq")
    public suspend fun resourceGuardOperationDetails(vararg values: Output<ResourceGuardOperationDetailArgs>) {
        this.resourceGuardOperationDetails = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("jpiddvvxwdwucxfi")
    public suspend fun resourceGuardOperationDetails(values: List<Output<ResourceGuardOperationDetailArgs>>) {
        this.resourceGuardOperationDetails = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("obysfexahgyxehdp")
    public suspend fun resourceGuardResourceId(`value`: Output<String>) {
        this.resourceGuardResourceId = value
    }

    /**
     * @param value
     */
    @JvmName("bwohtktfsrtflxus")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value
     */
    @JvmName("tqbxicgghryieykc")
    public suspend fun lastUpdatedTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastUpdatedTime = mapped
    }

    /**
     * @param value
     */
    @JvmName("bemxbfomxaxbixne")
    public suspend fun resourceGuardOperationDetails(`value`: List<ResourceGuardOperationDetailArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGuardOperationDetails = mapped
    }

    /**
     * @param argument
     */
    @JvmName("dkuxlojpcqimloyl")
    public suspend fun resourceGuardOperationDetails(argument: List<suspend ResourceGuardOperationDetailArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResourceGuardOperationDetailArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceGuardOperationDetails = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gwovyuqsiqngpulb")
    public suspend fun resourceGuardOperationDetails(vararg argument: suspend ResourceGuardOperationDetailArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ResourceGuardOperationDetailArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceGuardOperationDetails = mapped
    }

    /**
     * @param argument
     */
    @JvmName("hptoifjobhsckrxc")
    public suspend fun resourceGuardOperationDetails(argument: suspend ResourceGuardOperationDetailArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ResourceGuardOperationDetailArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.resourceGuardOperationDetails = mapped
    }

    /**
     * @param values
     */
    @JvmName("dbxrhoxpkuqxoopb")
    public suspend fun resourceGuardOperationDetails(vararg values: ResourceGuardOperationDetailArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceGuardOperationDetails = mapped
    }

    /**
     * @param value
     */
    @JvmName("jqlrquqodnmixmcr")
    public suspend fun resourceGuardResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGuardResourceId = mapped
    }

    internal fun build(): ResourceGuardProxyBaseArgs = ResourceGuardProxyBaseArgs(
        description = description,
        lastUpdatedTime = lastUpdatedTime,
        resourceGuardOperationDetails = resourceGuardOperationDetails,
        resourceGuardResourceId = resourceGuardResourceId,
    )
}
