@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.inputs

import com.pulumi.azurenative.dataprotection.inputs.SecretStoreBasedAuthCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Secret store based authentication credentials.
 * @property objectType Type of the specific object - used for deserializing
 * Expected value is 'SecretStoreBasedAuthCredentials'.
 * @property secretStoreResource Secret store resource
 */
public data class SecretStoreBasedAuthCredentialsArgs(
    public val objectType: Output<String>,
    public val secretStoreResource: Output<SecretStoreResourceArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.dataprotection.inputs.SecretStoreBasedAuthCredentialsArgs> {
    override fun toJava(): com.pulumi.azurenative.dataprotection.inputs.SecretStoreBasedAuthCredentialsArgs =
        com.pulumi.azurenative.dataprotection.inputs.SecretStoreBasedAuthCredentialsArgs.builder()
            .objectType(objectType.applyValue({ args0 -> args0 }))
            .secretStoreResource(
                secretStoreResource?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [SecretStoreBasedAuthCredentialsArgs].
 */
@PulumiTagMarker
public class SecretStoreBasedAuthCredentialsArgsBuilder internal constructor() {
    private var objectType: Output<String>? = null

    private var secretStoreResource: Output<SecretStoreResourceArgs>? = null

    /**
     * @param value Type of the specific object - used for deserializing
     * Expected value is 'SecretStoreBasedAuthCredentials'.
     */
    @JvmName("pbhyxoxrlksrgorh")
    public suspend fun objectType(`value`: Output<String>) {
        this.objectType = value
    }

    /**
     * @param value Secret store resource
     */
    @JvmName("dlxnjxknwsntirol")
    public suspend fun secretStoreResource(`value`: Output<SecretStoreResourceArgs>) {
        this.secretStoreResource = value
    }

    /**
     * @param value Type of the specific object - used for deserializing
     * Expected value is 'SecretStoreBasedAuthCredentials'.
     */
    @JvmName("qfjsotwbtlkftuio")
    public suspend fun objectType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectType = mapped
    }

    /**
     * @param value Secret store resource
     */
    @JvmName("tkamdvuetqqsgadt")
    public suspend fun secretStoreResource(`value`: SecretStoreResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretStoreResource = mapped
    }

    /**
     * @param argument Secret store resource
     */
    @JvmName("grrafkywljnsubnm")
    public suspend fun secretStoreResource(argument: suspend SecretStoreResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SecretStoreResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.secretStoreResource = mapped
    }

    internal fun build(): SecretStoreBasedAuthCredentialsArgs = SecretStoreBasedAuthCredentialsArgs(
        objectType = objectType ?: throw PulumiNullFieldException("objectType"),
        secretStoreResource = secretStoreResource,
    )
}
