@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Delete option with duration
 * @property duration Duration of deletion after given timespan
 * @property objectType Type of the specific object - used for deserializing
 * Expected value is 'AbsoluteDeleteOption'.
 */
public data class AbsoluteDeleteOptionResponse(
    public val duration: String,
    public val objectType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.AbsoluteDeleteOptionResponse): AbsoluteDeleteOptionResponse = AbsoluteDeleteOptionResponse(
            duration = javaType.duration(),
            objectType = javaType.objectType(),
        )
    }
}
