@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Adhoc trigger context
 * @property objectType Type of the specific object - used for deserializing
 * Expected value is 'AdhocBasedTriggerContext'.
 * @property taggingCriteria Tagging Criteria containing retention tag for adhoc backup.
 */
public data class AdhocBasedTriggerContextResponse(
    public val objectType: String,
    public val taggingCriteria: AdhocBasedTaggingCriteriaResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.AdhocBasedTriggerContextResponse): AdhocBasedTriggerContextResponse = AdhocBasedTriggerContextResponse(
            objectType = javaType.objectType(),
            taggingCriteria = javaType.taggingCriteria().let({ args0 ->
                com.pulumi.azurenative.dataprotection.kotlin.outputs.AdhocBasedTaggingCriteriaResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
