@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Azure retention rule
 * @property isDefault
 * @property lifecycles
 * @property name
 * @property objectType
 * Expected value is 'AzureRetentionRule'.
 */
public data class AzureRetentionRuleResponse(
    public val isDefault: Boolean? = null,
    public val lifecycles: List<SourceLifeCycleResponse>,
    public val name: String,
    public val objectType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.AzureRetentionRuleResponse): AzureRetentionRuleResponse = AzureRetentionRuleResponse(
            isDefault = javaType.isDefault().map({ args0 -> args0 }).orElse(null),
            lifecycles = javaType.lifecycles().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dataprotection.kotlin.outputs.SourceLifeCycleResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            objectType = javaType.objectType(),
        )
    }
}
