@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Backup Instance
 * @property currentProtectionState Specifies the current protection state of the resource
 * @property dataSourceInfo Gets or sets the data source information.
 * @property dataSourceSetInfo Gets or sets the data source set information.
 * @property datasourceAuthCredentials Credentials to use to authenticate with data source provider.
 * @property friendlyName Gets or sets the Backup Instance friendly name.
 * @property objectType
 * @property policyInfo Gets or sets the policy information.
 * @property protectionErrorDetails Specifies the protection error of the resource
 * @property protectionStatus Specifies the protection status of the resource
 * @property provisioningState Specifies the provisioning state of the resource i.e. provisioning/updating/Succeeded/Failed
 * @property validationType Specifies the type of validation. In case of DeepValidation, all validations from /validateForBackup API will run again.
 */
public data class BackupInstanceResponse(
    public val currentProtectionState: String,
    public val dataSourceInfo: DatasourceResponse,
    public val dataSourceSetInfo: DatasourceSetResponse? = null,
    public val datasourceAuthCredentials: SecretStoreBasedAuthCredentialsResponse? = null,
    public val friendlyName: String? = null,
    public val objectType: String,
    public val policyInfo: PolicyInfoResponse,
    public val protectionErrorDetails: UserFacingErrorResponse,
    public val protectionStatus: ProtectionStatusDetailsResponse,
    public val provisioningState: String,
    public val validationType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.BackupInstanceResponse): BackupInstanceResponse = BackupInstanceResponse(
            currentProtectionState = javaType.currentProtectionState(),
            dataSourceInfo = javaType.dataSourceInfo().let({ args0 ->
                com.pulumi.azurenative.dataprotection.kotlin.outputs.DatasourceResponse.Companion.toKotlin(args0)
            }),
            dataSourceSetInfo = javaType.dataSourceSetInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dataprotection.kotlin.outputs.DatasourceSetResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            datasourceAuthCredentials = javaType.datasourceAuthCredentials().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dataprotection.kotlin.outputs.SecretStoreBasedAuthCredentialsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            friendlyName = javaType.friendlyName().map({ args0 -> args0 }).orElse(null),
            objectType = javaType.objectType(),
            policyInfo = javaType.policyInfo().let({ args0 ->
                com.pulumi.azurenative.dataprotection.kotlin.outputs.PolicyInfoResponse.Companion.toKotlin(args0)
            }),
            protectionErrorDetails = javaType.protectionErrorDetails().let({ args0 ->
                com.pulumi.azurenative.dataprotection.kotlin.outputs.UserFacingErrorResponse.Companion.toKotlin(args0)
            }),
            protectionStatus = javaType.protectionStatus().let({ args0 ->
                com.pulumi.azurenative.dataprotection.kotlin.outputs.ProtectionStatusDetailsResponse.Companion.toKotlin(args0)
            }),
            provisioningState = javaType.provisioningState(),
            validationType = javaType.validationType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
