@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Rule based backup policy
 * @property datasourceTypes Type of datasource for the backup management
 * @property objectType
 * Expected value is 'BackupPolicy'.
 * @property policyRules Policy rule dictionary that contains rules for each backuptype i.e Full/Incremental/Logs etc
 */
public data class BackupPolicyResponse(
    public val datasourceTypes: List<String>,
    public val objectType: String,
    public val policyRules: List<Either<AzureBackupRuleResponse, AzureRetentionRuleResponse>>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.BackupPolicyResponse): BackupPolicyResponse = BackupPolicyResponse(
            datasourceTypes = javaType.datasourceTypes().map({ args0 -> args0 }),
            objectType = javaType.objectType(),
            policyRules = javaType.policyRules().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.dataprotection.kotlin.outputs.AzureBackupRuleResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.dataprotection.kotlin.outputs.AzureRetentionRuleResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }),
        )
    }
}
