@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Schedule for backup
 * @property repeatingTimeIntervals ISO 8601 repeating time interval format
 * @property timeZone Time zone for a schedule. Example: Pacific Standard Time
 */
public data class BackupScheduleResponse(
    public val repeatingTimeIntervals: List<String>,
    public val timeZone: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.BackupScheduleResponse): BackupScheduleResponse = BackupScheduleResponse(
            repeatingTimeIntervals = javaType.repeatingTimeIntervals().map({ args0 -> args0 }),
            timeZone = javaType.timeZone().map({ args0 -> args0 }).orElse(null),
        )
    }
}
