@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Parameters to be used during configuration of backup of blobs
 * @property containersList List of containers to be backed up during configuration of backup of blobs
 * @property objectType Type of the specific object - used for deserializing
 * Expected value is 'BlobBackupDatasourceParameters'.
 */
public data class BlobBackupDatasourceParametersResponse(
    public val containersList: List<String>,
    public val objectType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.BlobBackupDatasourceParametersResponse): BlobBackupDatasourceParametersResponse = BlobBackupDatasourceParametersResponse(
            containersList = javaType.containersList().map({ args0 -> args0 }),
            objectType = javaType.objectType(),
        )
    }
}
