@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Copy on Expiry Option
 * @property objectType Type of the specific object - used for deserializing
 * Expected value is 'CopyOnExpiryOption'.
 */
public data class CopyOnExpiryOptionResponse(
    public val objectType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.CopyOnExpiryOptionResponse): CopyOnExpiryOptionResponse = CopyOnExpiryOptionResponse(
            objectType = javaType.objectType(),
        )
    }
}
