@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Datasource to be backed up
 * @property datasourceType DatasourceType of the resource.
 * @property objectType Type of Datasource object, used to initialize the right inherited type
 * @property resourceID Full ARM ID of the resource. For azure resources, this is ARM ID. For non azure resources, this will be the ID created by backup service via Fabric/Vault.
 * @property resourceLocation Location of datasource.
 * @property resourceName Unique identifier of the resource in the context of parent.
 * @property resourceType Resource Type of Datasource.
 * @property resourceUri Uri of the resource.
 */
public data class DatasourceResponse(
    public val datasourceType: String? = null,
    public val objectType: String? = null,
    public val resourceID: String,
    public val resourceLocation: String? = null,
    public val resourceName: String? = null,
    public val resourceType: String? = null,
    public val resourceUri: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.DatasourceResponse): DatasourceResponse = DatasourceResponse(
            datasourceType = javaType.datasourceType().map({ args0 -> args0 }).orElse(null),
            objectType = javaType.objectType().map({ args0 -> args0 }).orElse(null),
            resourceID = javaType.resourceID(),
            resourceLocation = javaType.resourceLocation().map({ args0 -> args0 }).orElse(null),
            resourceName = javaType.resourceName().map({ args0 -> args0 }).orElse(null),
            resourceType = javaType.resourceType().map({ args0 -> args0 }).orElse(null),
            resourceUri = javaType.resourceUri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
