@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * BaseBackupPolicy resource
 * @property id Resource Id represents the complete path to the resource.
 * @property name Resource name associated with the resource.
 * @property properties BaseBackupPolicyResource properties
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
 */
public data class GetBackupPolicyResult(
    public val id: String,
    public val name: String,
    public val properties: BackupPolicyResponse,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.GetBackupPolicyResult): GetBackupPolicyResult = GetBackupPolicyResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.dataprotection.kotlin.outputs.BackupPolicyResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.dataprotection.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
