@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Parameters for Kubernetes Cluster Backup Datasource
 * @property excludedNamespaces Gets or sets the exclude namespaces property. This property sets the namespaces to be excluded during restore.
 * @property excludedResourceTypes Gets or sets the exclude resource types property. This property sets the resource types to be excluded during restore.
 * @property includeClusterScopeResources Gets or sets the include cluster resources property. This property if enabled will include cluster scope resources during restore.
 * @property includedNamespaces Gets or sets the include namespaces property. This property sets the namespaces to be included during restore.
 * @property includedResourceTypes Gets or sets the include resource types property. This property sets the resource types to be included during restore.
 * @property labelSelectors Gets or sets the LabelSelectors property. This property sets the resource with such label selectors to be included during restore.
 * @property objectType Type of the specific object - used for deserializing
 * Expected value is 'KubernetesClusterBackupDatasourceParameters'.
 * @property snapshotVolumes Gets or sets the volume snapshot property. This property if enabled will take volume snapshots during restore.
 */
public data class KubernetesClusterBackupDatasourceParametersResponse(
    public val excludedNamespaces: List<String>? = null,
    public val excludedResourceTypes: List<String>? = null,
    public val includeClusterScopeResources: Boolean,
    public val includedNamespaces: List<String>? = null,
    public val includedResourceTypes: List<String>? = null,
    public val labelSelectors: List<String>? = null,
    public val objectType: String,
    public val snapshotVolumes: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.KubernetesClusterBackupDatasourceParametersResponse): KubernetesClusterBackupDatasourceParametersResponse =
            KubernetesClusterBackupDatasourceParametersResponse(
                excludedNamespaces = javaType.excludedNamespaces().map({ args0 -> args0 }),
                excludedResourceTypes = javaType.excludedResourceTypes().map({ args0 -> args0 }),
                includeClusterScopeResources = javaType.includeClusterScopeResources(),
                includedNamespaces = javaType.includedNamespaces().map({ args0 -> args0 }),
                includedResourceTypes = javaType.includedResourceTypes().map({ args0 -> args0 }),
                labelSelectors = javaType.labelSelectors().map({ args0 -> args0 }),
                objectType = javaType.objectType(),
                snapshotVolumes = javaType.snapshotVolumes(),
            )
    }
}
