@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Policy Info in backupInstance
 * @property policyId
 * @property policyParameters Policy parameters for the backup instance
 * @property policyVersion
 */
public data class PolicyInfoResponse(
    public val policyId: String,
    public val policyParameters: PolicyParametersResponse? = null,
    public val policyVersion: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.PolicyInfoResponse): PolicyInfoResponse = PolicyInfoResponse(
            policyId = javaType.policyId(),
            policyParameters = javaType.policyParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dataprotection.kotlin.outputs.PolicyParametersResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            policyVersion = javaType.policyVersion(),
        )
    }
}
