@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Suppress
import kotlin.collections.List

/**
 * Parameters in Policy
 * @property backupDatasourceParametersList Gets or sets the Backup Data Source Parameters
 * @property dataStoreParametersList Gets or sets the DataStore Parameters
 */
public data class PolicyParametersResponse(
    public val backupDatasourceParametersList: List<Either<BlobBackupDatasourceParametersResponse, KubernetesClusterBackupDatasourceParametersResponse>>? =
        null,
    public val dataStoreParametersList: List<AzureOperationalStoreParametersResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.PolicyParametersResponse): PolicyParametersResponse = PolicyParametersResponse(
            backupDatasourceParametersList = javaType.backupDatasourceParametersList().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.dataprotection.kotlin.outputs.BlobBackupDatasourceParametersResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.dataprotection.kotlin.outputs.KubernetesClusterBackupDatasourceParametersResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }),
            dataStoreParametersList = javaType.dataStoreParametersList().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dataprotection.kotlin.outputs.AzureOperationalStoreParametersResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
