@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Protection status details
 * @property errorDetails Specifies the protection status error of the resource
 * @property status Specifies the protection status of the resource
 */
public data class ProtectionStatusDetailsResponse(
    public val errorDetails: UserFacingErrorResponse? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.ProtectionStatusDetailsResponse): ProtectionStatusDetailsResponse = ProtectionStatusDetailsResponse(
            errorDetails = javaType.errorDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dataprotection.kotlin.outputs.UserFacingErrorResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
