@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * ResourceGuardProxyBase object, used in ResourceGuardProxyBaseResource
 * @property description
 * @property lastUpdatedTime
 * @property resourceGuardOperationDetails
 * @property resourceGuardResourceId
 */
public data class ResourceGuardProxyBaseResponse(
    public val description: String? = null,
    public val lastUpdatedTime: String? = null,
    public val resourceGuardOperationDetails: List<ResourceGuardOperationDetailResponse>? = null,
    public val resourceGuardResourceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.ResourceGuardProxyBaseResponse): ResourceGuardProxyBaseResponse = ResourceGuardProxyBaseResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            lastUpdatedTime = javaType.lastUpdatedTime().map({ args0 -> args0 }).orElse(null),
            resourceGuardOperationDetails = javaType.resourceGuardOperationDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dataprotection.kotlin.outputs.ResourceGuardOperationDetailResponse.Companion.toKotlin(args0)
                })
            }),
            resourceGuardResourceId = javaType.resourceGuardResourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
