@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allowAutoApprovals This flag indicates whether auto approval is allowed or not.
 * @property description Description about the pre-req steps to perform all the critical operations.
 * @property provisioningState Provisioning state of the BackupVault resource
 * @property resourceGuardOperations {readonly} List of operation details those are protected by the ResourceGuard resource
 * @property vaultCriticalOperationExclusionList List of critical operations which are not protected by this resourceGuard
 */
public data class ResourceGuardResponse(
    public val allowAutoApprovals: Boolean,
    public val description: String,
    public val provisioningState: String,
    public val resourceGuardOperations: List<ResourceGuardOperationResponse>,
    public val vaultCriticalOperationExclusionList: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.ResourceGuardResponse): ResourceGuardResponse = ResourceGuardResponse(
            allowAutoApprovals = javaType.allowAutoApprovals(),
            description = javaType.description(),
            provisioningState = javaType.provisioningState(),
            resourceGuardOperations = javaType.resourceGuardOperations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dataprotection.kotlin.outputs.ResourceGuardOperationResponse.Companion.toKotlin(args0)
                })
            }),
            vaultCriticalOperationExclusionList = javaType.vaultCriticalOperationExclusionList().map({ args0 ->
                args0
            }),
        )
    }
}
