@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * ResourceMoveDetails will be returned in response to GetResource call from ARM
 * @property completionTimeUtc Completion time in UTC of latest ResourceMove operation attempted. ISO 8601 format.
 * @property operationId CorrelationId of latest ResourceMove operation attempted
 * @property sourceResourcePath ARM resource path of source resource
 * @property startTimeUtc Start time in UTC of latest ResourceMove operation attempted. ISO 8601 format.
 * @property targetResourcePath ARM resource path of target resource used in latest ResourceMove operation
 */
public data class ResourceMoveDetailsResponse(
    public val completionTimeUtc: String? = null,
    public val operationId: String? = null,
    public val sourceResourcePath: String? = null,
    public val startTimeUtc: String? = null,
    public val targetResourcePath: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.ResourceMoveDetailsResponse): ResourceMoveDetailsResponse = ResourceMoveDetailsResponse(
            completionTimeUtc = javaType.completionTimeUtc().map({ args0 -> args0 }).orElse(null),
            operationId = javaType.operationId().map({ args0 -> args0 }).orElse(null),
            sourceResourcePath = javaType.sourceResourcePath().map({ args0 -> args0 }).orElse(null),
            startTimeUtc = javaType.startTimeUtc().map({ args0 -> args0 }).orElse(null),
            targetResourcePath = javaType.targetResourcePath().map({ args0 -> args0 }).orElse(null),
        )
    }
}
