@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Schedule based backup criteria
 * @property absoluteCriteria it contains absolute values like "AllBackup" / "FirstOfDay" / "FirstOfWeek" / "FirstOfMonth"
 * and should be part of AbsoluteMarker enum
 * @property daysOfMonth This is day of the month from 1 to 28 other wise last of month
 * @property daysOfTheWeek It should be Sunday/Monday/T..../Saturday
 * @property monthsOfYear It should be January/February/....../December
 * @property objectType Type of the specific object - used for deserializing
 * Expected value is 'ScheduleBasedBackupCriteria'.
 * @property scheduleTimes List of schedule times for backup
 * @property weeksOfTheMonth It should be First/Second/Third/Fourth/Last
 */
public data class ScheduleBasedBackupCriteriaResponse(
    public val absoluteCriteria: List<String>? = null,
    public val daysOfMonth: List<DayResponse>? = null,
    public val daysOfTheWeek: List<String>? = null,
    public val monthsOfYear: List<String>? = null,
    public val objectType: String,
    public val scheduleTimes: List<String>? = null,
    public val weeksOfTheMonth: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.ScheduleBasedBackupCriteriaResponse): ScheduleBasedBackupCriteriaResponse = ScheduleBasedBackupCriteriaResponse(
            absoluteCriteria = javaType.absoluteCriteria().map({ args0 -> args0 }),
            daysOfMonth = javaType.daysOfMonth().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dataprotection.kotlin.outputs.DayResponse.Companion.toKotlin(args0)
                })
            }),
            daysOfTheWeek = javaType.daysOfTheWeek().map({ args0 -> args0 }),
            monthsOfYear = javaType.monthsOfYear().map({ args0 -> args0 }),
            objectType = javaType.objectType(),
            scheduleTimes = javaType.scheduleTimes().map({ args0 -> args0 }),
            weeksOfTheMonth = javaType.weeksOfTheMonth().map({ args0 -> args0 }),
        )
    }
}
