@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Class representing a secret store resource.
 * @property secretStoreType Gets or sets the type of secret store
 * @property uri Uri to get to the resource
 * @property value Gets or sets value stored in secret store resource
 */
public data class SecretStoreResourceResponse(
    public val secretStoreType: String,
    public val uri: String? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.SecretStoreResourceResponse): SecretStoreResourceResponse = SecretStoreResourceResponse(
            secretStoreType = javaType.secretStoreType(),
            uri = javaType.uri().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
