@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.Suppress

/**
 * Class containing security settings of vault
 * @property immutabilitySettings Immutability Settings at vault level
 * @property softDeleteSettings Soft delete related settings
 */
public data class SecuritySettingsResponse(
    public val immutabilitySettings: ImmutabilitySettingsResponse? = null,
    public val softDeleteSettings: SoftDeleteSettingsResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.SecuritySettingsResponse): SecuritySettingsResponse = SecuritySettingsResponse(
            immutabilitySettings = javaType.immutabilitySettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dataprotection.kotlin.outputs.ImmutabilitySettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            softDeleteSettings = javaType.softDeleteSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dataprotection.kotlin.outputs.SoftDeleteSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
