@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Soft delete related settings
 * @property retentionDurationInDays Soft delete retention duration
 * @property state State of soft delete
 */
public data class SoftDeleteSettingsResponse(
    public val retentionDurationInDays: Double? = null,
    public val state: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.SoftDeleteSettingsResponse): SoftDeleteSettingsResponse = SoftDeleteSettingsResponse(
            retentionDurationInDays = javaType.retentionDurationInDays().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
        )
    }
}
