@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.Any
import kotlin.Suppress

/**
 * Target copy settings
 * @property copyAfter It can be CustomCopyOption or ImmediateCopyOption.
 * @property dataStore Info of target datastore
 */
public data class TargetCopySettingResponse(
    public val copyAfter: Any,
    public val dataStore: DataStoreInfoBaseResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.TargetCopySettingResponse): TargetCopySettingResponse = TargetCopySettingResponse(
            copyAfter = javaType.copyAfter(),
            dataStore = javaType.dataStore().let({ args0 ->
                com.pulumi.azurenative.dataprotection.kotlin.outputs.DataStoreInfoBaseResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
