@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin

import com.pulumi.azurenative.datareplication.DraArgs.builder
import com.pulumi.azurenative.datareplication.kotlin.inputs.DraModelPropertiesArgs
import com.pulumi.azurenative.datareplication.kotlin.inputs.DraModelPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Dra model.
 * Azure REST API version: 2021-02-16-preview.
 * ## Example Usage
 * ### Dra_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dra = new AzureNative.DataReplication.Dra("dra", new()
 *     {
 *         FabricAgentName = "M",
 *         FabricName = "wPR",
 *         Properties = new AzureNative.DataReplication.Inputs.DraModelPropertiesArgs
 *         {
 *             AuthenticationIdentity = new AzureNative.DataReplication.Inputs.IdentityModelArgs
 *             {
 *                 AadAuthority = "bubwwbowfhdmujrt",
 *                 ApplicationId = "cwktzrwajuvfyyymfstpey",
 *                 Audience = "dkjobanyqgzenivyxhvavottpc",
 *                 ObjectId = "khsiaqfbpuhp",
 *                 TenantId = "joclkkdovixwapephhxaqtefubhhmq",
 *             },
 *             CustomProperties = null,
 *             MachineId = "envzcoijbqhtrpncbjbhk",
 *             MachineName = "y",
 *             ResourceAccessIdentity = new AzureNative.DataReplication.Inputs.IdentityModelArgs
 *             {
 *                 AadAuthority = "bubwwbowfhdmujrt",
 *                 ApplicationId = "cwktzrwajuvfyyymfstpey",
 *                 Audience = "dkjobanyqgzenivyxhvavottpc",
 *                 ObjectId = "khsiaqfbpuhp",
 *                 TenantId = "joclkkdovixwapephhxaqtefubhhmq",
 *             },
 *         },
 *         ResourceGroupName = "rgrecoveryservicesdatareplication",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datareplication/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datareplication.NewDra(ctx, "dra", &datareplication.DraArgs{
 * 			FabricAgentName: pulumi.String("M"),
 * 			FabricName:      pulumi.String("wPR"),
 * 			Properties: &datareplication.DraModelPropertiesArgs{
 * 				AuthenticationIdentity: &datareplication.IdentityModelArgs{
 * 					AadAuthority:  pulumi.String("bubwwbowfhdmujrt"),
 * 					ApplicationId: pulumi.String("cwktzrwajuvfyyymfstpey"),
 * 					Audience:      pulumi.String("dkjobanyqgzenivyxhvavottpc"),
 * 					ObjectId:      pulumi.String("khsiaqfbpuhp"),
 * 					TenantId:      pulumi.String("joclkkdovixwapephhxaqtefubhhmq"),
 * 				},
 * 				CustomProperties: nil,
 * 				MachineId:        pulumi.String("envzcoijbqhtrpncbjbhk"),
 * 				MachineName:      pulumi.String("y"),
 * 				ResourceAccessIdentity: &datareplication.IdentityModelArgs{
 * 					AadAuthority:  pulumi.String("bubwwbowfhdmujrt"),
 * 					ApplicationId: pulumi.String("cwktzrwajuvfyyymfstpey"),
 * 					Audience:      pulumi.String("dkjobanyqgzenivyxhvavottpc"),
 * 					ObjectId:      pulumi.String("khsiaqfbpuhp"),
 * 					TenantId:      pulumi.String("joclkkdovixwapephhxaqtefubhhmq"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rgrecoveryservicesdatareplication"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datareplication.Dra;
 * import com.pulumi.azurenative.datareplication.DraArgs;
 * import com.pulumi.azurenative.datareplication.inputs.DraModelPropertiesArgs;
 * import com.pulumi.azurenative.datareplication.inputs.IdentityModelArgs;
 * import com.pulumi.azurenative.datareplication.inputs.VMwareDraModelCustomPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dra = new Dra("dra", DraArgs.builder()
 *             .fabricAgentName("M")
 *             .fabricName("wPR")
 *             .properties(DraModelPropertiesArgs.builder()
 *                 .authenticationIdentity(IdentityModelArgs.builder()
 *                     .aadAuthority("bubwwbowfhdmujrt")
 *                     .applicationId("cwktzrwajuvfyyymfstpey")
 *                     .audience("dkjobanyqgzenivyxhvavottpc")
 *                     .objectId("khsiaqfbpuhp")
 *                     .tenantId("joclkkdovixwapephhxaqtefubhhmq")
 *                     .build())
 *                 .customProperties()
 *                 .machineId("envzcoijbqhtrpncbjbhk")
 *                 .machineName("y")
 *                 .resourceAccessIdentity(IdentityModelArgs.builder()
 *                     .aadAuthority("bubwwbowfhdmujrt")
 *                     .applicationId("cwktzrwajuvfyyymfstpey")
 *                     .audience("dkjobanyqgzenivyxhvavottpc")
 *                     .objectId("khsiaqfbpuhp")
 *                     .tenantId("joclkkdovixwapephhxaqtefubhhmq")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("rgrecoveryservicesdatareplication")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datareplication:Dra ioxmwhzrzdilxivkvhpvzexl /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationFabrics/{fabricName}/fabricAgents/{fabricAgentName}
 * ```
 * @property fabricAgentName The fabric agent (Dra) name.
 * @property fabricName The fabric name.
 * @property properties Dra model properties.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class DraArgs(
    public val fabricAgentName: Output<String>? = null,
    public val fabricName: Output<String>? = null,
    public val properties: Output<DraModelPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datareplication.DraArgs> {
    override fun toJava(): com.pulumi.azurenative.datareplication.DraArgs =
        com.pulumi.azurenative.datareplication.DraArgs.builder()
            .fabricAgentName(fabricAgentName?.applyValue({ args0 -> args0 }))
            .fabricName(fabricName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DraArgs].
 */
@PulumiTagMarker
public class DraArgsBuilder internal constructor() {
    private var fabricAgentName: Output<String>? = null

    private var fabricName: Output<String>? = null

    private var properties: Output<DraModelPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The fabric agent (Dra) name.
     */
    @JvmName("trisujxxaqncsmwu")
    public suspend fun fabricAgentName(`value`: Output<String>) {
        this.fabricAgentName = value
    }

    /**
     * @param value The fabric name.
     */
    @JvmName("wijiprobabcxntnu")
    public suspend fun fabricName(`value`: Output<String>) {
        this.fabricName = value
    }

    /**
     * @param value Dra model properties.
     */
    @JvmName("wggbvmvmyvcpmwlq")
    public suspend fun properties(`value`: Output<DraModelPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ubkieoccbqdpxfnj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The fabric agent (Dra) name.
     */
    @JvmName("wfylpcyynwywcnie")
    public suspend fun fabricAgentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fabricAgentName = mapped
    }

    /**
     * @param value The fabric name.
     */
    @JvmName("yoempybexuiqibxf")
    public suspend fun fabricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fabricName = mapped
    }

    /**
     * @param value Dra model properties.
     */
    @JvmName("auggjpsmtviyurdq")
    public suspend fun properties(`value`: DraModelPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Dra model properties.
     */
    @JvmName("mhlhkqrbnnnwxsuu")
    public suspend fun properties(argument: suspend DraModelPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DraModelPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dellhttqtmvbpnfx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): DraArgs = DraArgs(
        fabricAgentName = fabricAgentName,
        fabricName = fabricName,
        properties = properties,
        resourceGroupName = resourceGroupName,
    )
}
