@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin

import com.pulumi.azurenative.datareplication.kotlin.outputs.FabricModelPropertiesResponse
import com.pulumi.azurenative.datareplication.kotlin.outputs.FabricModelResponseSystemData
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.datareplication.kotlin.outputs.FabricModelPropertiesResponse.Companion.toKotlin as fabricModelPropertiesResponseToKotlin
import com.pulumi.azurenative.datareplication.kotlin.outputs.FabricModelResponseSystemData.Companion.toKotlin as fabricModelResponseSystemDataToKotlin

/**
 * Builder for [Fabric].
 */
@PulumiTagMarker
public class FabricResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FabricArgs = FabricArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FabricArgsBuilder.() -> Unit) {
        val builder = FabricArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Fabric {
        val builtJavaResource = com.pulumi.azurenative.datareplication.Fabric(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Fabric(builtJavaResource)
    }
}

/**
 * Fabric model.
 * Azure REST API version: 2021-02-16-preview.
 * ## Example Usage
 * ### Fabric_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fabric = new AzureNative.DataReplication.Fabric("fabric", new()
 *     {
 *         FabricName = "wPR",
 *         Location = "tqygutlpob",
 *         Properties = new AzureNative.DataReplication.Inputs.FabricModelPropertiesArgs
 *         {
 *             CustomProperties =
 *             {
 *                 { "instanceType", "FabricModelCustomProperties" },
 *             },
 *         },
 *         ResourceGroupName = "rgrecoveryservicesdatareplication",
 *         Tags =
 *         {
 *             { "key3917", "vgralu" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datareplication/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := datareplication.NewFabric(ctx, "fabric", &datareplication.FabricArgs{
 * FabricName: pulumi.String("wPR"),
 * Location: pulumi.String("tqygutlpob"),
 * Properties: &datareplication.FabricModelPropertiesArgs{
 * CustomProperties: interface{}{
 * InstanceType: pulumi.String("FabricModelCustomProperties"),
 * },
 * },
 * ResourceGroupName: pulumi.String("rgrecoveryservicesdatareplication"),
 * Tags: pulumi.StringMap{
 * "key3917": pulumi.String("vgralu"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datareplication.Fabric;
 * import com.pulumi.azurenative.datareplication.FabricArgs;
 * import com.pulumi.azurenative.datareplication.inputs.FabricModelPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fabric = new Fabric("fabric", FabricArgs.builder()
 *             .fabricName("wPR")
 *             .location("tqygutlpob")
 *             .properties(FabricModelPropertiesArgs.builder()
 *                 .customProperties(AzStackHCIFabricModelCustomPropertiesArgs.builder()
 *                     .instanceType("FabricModelCustomProperties")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("rgrecoveryservicesdatareplication")
 *             .tags(Map.of("key3917", "vgralu"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datareplication:Fabric rhojydcwjgvgexpdwswjib /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationFabrics/{fabricName}
 * ```
 */
public class Fabric internal constructor(
    override val javaResource: com.pulumi.azurenative.datareplication.Fabric,
) : KotlinCustomResource(javaResource, FabricMapper) {
    /**
     * Gets or sets the location of the fabric.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Fabric model properties.
     */
    public val properties: Output<FabricModelPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                fabricModelPropertiesResponseToKotlin(args0)
            })
        })

    public val systemData: Output<FabricModelResponseSystemData>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                fabricModelResponseSystemDataToKotlin(args0)
            })
        })

    /**
     * Gets or sets the resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Gets or sets the type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object FabricMapper : ResourceMapper<Fabric> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datareplication.Fabric::class == javaResource::class

    override fun map(javaResource: Resource): Fabric = Fabric(
        javaResource as
            com.pulumi.azurenative.datareplication.Fabric,
    )
}

/**
 * @see [Fabric].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Fabric].
 */
public suspend fun fabric(name: String, block: suspend FabricResourceBuilder.() -> Unit): Fabric {
    val builder = FabricResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Fabric].
 * @param name The _unique_ name of the resulting resource.
 */
public fun fabric(name: String): Fabric {
    val builder = FabricResourceBuilder()
    builder.name(name)
    return builder.build()
}
