@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin

import com.pulumi.azurenative.datareplication.ProtectedItemArgs.builder
import com.pulumi.azurenative.datareplication.kotlin.inputs.ProtectedItemModelPropertiesArgs
import com.pulumi.azurenative.datareplication.kotlin.inputs.ProtectedItemModelPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Protected item model.
 * Azure REST API version: 2021-02-16-preview.
 * ## Example Usage
 * ### ProtectedItem_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var protectedItem = new AzureNative.DataReplication.ProtectedItem("protectedItem", new()
 *     {
 *         Properties = new AzureNative.DataReplication.Inputs.ProtectedItemModelPropertiesArgs
 *         {
 *             CustomProperties =
 *             {
 *                 { "instanceType", "ProtectedItemModelCustomProperties" },
 *             },
 *             PolicyName = "tjoeiynplt",
 *             ReplicationExtensionName = "jwxdo",
 *         },
 *         ProtectedItemName = "d",
 *         ResourceGroupName = "rgrecoveryservicesdatareplication",
 *         VaultName = "4",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datareplication/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := datareplication.NewProtectedItem(ctx, "protectedItem", &datareplication.ProtectedItemArgs{
 * Properties: &datareplication.ProtectedItemModelPropertiesArgs{
 * CustomProperties: interface{}{
 * InstanceType: pulumi.String("ProtectedItemModelCustomProperties"),
 * },
 * PolicyName: pulumi.String("tjoeiynplt"),
 * ReplicationExtensionName: pulumi.String("jwxdo"),
 * },
 * ProtectedItemName: pulumi.String("d"),
 * ResourceGroupName: pulumi.String("rgrecoveryservicesdatareplication"),
 * VaultName: pulumi.String("4"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datareplication.ProtectedItem;
 * import com.pulumi.azurenative.datareplication.ProtectedItemArgs;
 * import com.pulumi.azurenative.datareplication.inputs.ProtectedItemModelPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var protectedItem = new ProtectedItem("protectedItem", ProtectedItemArgs.builder()
 *             .properties(ProtectedItemModelPropertiesArgs.builder()
 *                 .customProperties(HyperVToAzStackHCIProtectedItemModelCustomPropertiesArgs.builder()
 *                     .instanceType("ProtectedItemModelCustomProperties")
 *                     .build())
 *                 .policyName("tjoeiynplt")
 *                 .replicationExtensionName("jwxdo")
 *                 .build())
 *             .protectedItemName("d")
 *             .resourceGroupName("rgrecoveryservicesdatareplication")
 *             .vaultName("4")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datareplication:ProtectedItem t /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationVaults/{vaultName}/protectedItems/{protectedItemName}
 * ```
 * @property properties Protected item model properties.
 * @property protectedItemName The protected item name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property vaultName The vault name.
 */
public data class ProtectedItemArgs(
    public val properties: Output<ProtectedItemModelPropertiesArgs>? = null,
    public val protectedItemName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val vaultName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datareplication.ProtectedItemArgs> {
    override fun toJava(): com.pulumi.azurenative.datareplication.ProtectedItemArgs =
        com.pulumi.azurenative.datareplication.ProtectedItemArgs.builder()
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .protectedItemName(protectedItemName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .vaultName(vaultName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProtectedItemArgs].
 */
@PulumiTagMarker
public class ProtectedItemArgsBuilder internal constructor() {
    private var properties: Output<ProtectedItemModelPropertiesArgs>? = null

    private var protectedItemName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var vaultName: Output<String>? = null

    /**
     * @param value Protected item model properties.
     */
    @JvmName("ywrwanpeetcotyra")
    public suspend fun properties(`value`: Output<ProtectedItemModelPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The protected item name.
     */
    @JvmName("tvlarksixliodhnj")
    public suspend fun protectedItemName(`value`: Output<String>) {
        this.protectedItemName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ueqinqmjsnenvyif")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The vault name.
     */
    @JvmName("xocrlcrxbgowmwkj")
    public suspend fun vaultName(`value`: Output<String>) {
        this.vaultName = value
    }

    /**
     * @param value Protected item model properties.
     */
    @JvmName("tvybnvtxtpehnsqe")
    public suspend fun properties(`value`: ProtectedItemModelPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Protected item model properties.
     */
    @JvmName("bxdqysdtekimloto")
    public suspend fun properties(argument: suspend ProtectedItemModelPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ProtectedItemModelPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The protected item name.
     */
    @JvmName("tyxskgyexkokcpej")
    public suspend fun protectedItemName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedItemName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("aaqsjdyhxxmhkeag")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The vault name.
     */
    @JvmName("rqbxqfyjdfjpewpe")
    public suspend fun vaultName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultName = mapped
    }

    internal fun build(): ProtectedItemArgs = ProtectedItemArgs(
        properties = properties,
        protectedItemName = protectedItemName,
        resourceGroupName = resourceGroupName,
        vaultName = vaultName,
    )
}
