@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.inputs

import com.pulumi.azurenative.datareplication.inputs.DraModelPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Dra model properties.
 * @property authenticationIdentity Identity model.
 * @property customProperties Dra model custom properties.
 * @property machineId Gets or sets the machine Id where Dra is running.
 * @property machineName Gets or sets the machine name where Dra is running.
 * @property resourceAccessIdentity Identity model.
 */
public data class DraModelPropertiesArgs(
    public val authenticationIdentity: Output<IdentityModelArgs>,
    public val customProperties: Output<VMwareDraModelCustomPropertiesArgs>,
    public val machineId: Output<String>,
    public val machineName: Output<String>,
    public val resourceAccessIdentity: Output<IdentityModelArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.datareplication.inputs.DraModelPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.datareplication.inputs.DraModelPropertiesArgs =
        com.pulumi.azurenative.datareplication.inputs.DraModelPropertiesArgs.builder()
            .authenticationIdentity(
                authenticationIdentity.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .customProperties(customProperties.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .machineId(machineId.applyValue({ args0 -> args0 }))
            .machineName(machineName.applyValue({ args0 -> args0 }))
            .resourceAccessIdentity(
                resourceAccessIdentity.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DraModelPropertiesArgs].
 */
@PulumiTagMarker
public class DraModelPropertiesArgsBuilder internal constructor() {
    private var authenticationIdentity: Output<IdentityModelArgs>? = null

    private var customProperties: Output<VMwareDraModelCustomPropertiesArgs>? = null

    private var machineId: Output<String>? = null

    private var machineName: Output<String>? = null

    private var resourceAccessIdentity: Output<IdentityModelArgs>? = null

    /**
     * @param value Identity model.
     */
    @JvmName("mhiqdvmhhfbnatgt")
    public suspend fun authenticationIdentity(`value`: Output<IdentityModelArgs>) {
        this.authenticationIdentity = value
    }

    /**
     * @param value Dra model custom properties.
     */
    @JvmName("lfyqvtbwwlsxlpuu")
    public suspend fun customProperties(`value`: Output<VMwareDraModelCustomPropertiesArgs>) {
        this.customProperties = value
    }

    /**
     * @param value Gets or sets the machine Id where Dra is running.
     */
    @JvmName("wrbnxvihaerkctsm")
    public suspend fun machineId(`value`: Output<String>) {
        this.machineId = value
    }

    /**
     * @param value Gets or sets the machine name where Dra is running.
     */
    @JvmName("rndrcpkxxmdeojlu")
    public suspend fun machineName(`value`: Output<String>) {
        this.machineName = value
    }

    /**
     * @param value Identity model.
     */
    @JvmName("gsckvlacjteyingb")
    public suspend fun resourceAccessIdentity(`value`: Output<IdentityModelArgs>) {
        this.resourceAccessIdentity = value
    }

    /**
     * @param value Identity model.
     */
    @JvmName("vmmeorrwswxhrkln")
    public suspend fun authenticationIdentity(`value`: IdentityModelArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationIdentity = mapped
    }

    /**
     * @param argument Identity model.
     */
    @JvmName("moceqoohutvrgfmn")
    public suspend fun authenticationIdentity(argument: suspend IdentityModelArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityModelArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.authenticationIdentity = mapped
    }

    /**
     * @param value Dra model custom properties.
     */
    @JvmName("vnngfgnqnjuytfda")
    public suspend fun customProperties(`value`: VMwareDraModelCustomPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customProperties = mapped
    }

    /**
     * @param argument Dra model custom properties.
     */
    @JvmName("pimcuahmfxoxgkwu")
    public suspend fun customProperties(argument: suspend VMwareDraModelCustomPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = VMwareDraModelCustomPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customProperties = mapped
    }

    /**
     * @param value Gets or sets the machine Id where Dra is running.
     */
    @JvmName("rdkawtjpytveveaf")
    public suspend fun machineId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.machineId = mapped
    }

    /**
     * @param value Gets or sets the machine name where Dra is running.
     */
    @JvmName("ftetfpenybgsbsqx")
    public suspend fun machineName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.machineName = mapped
    }

    /**
     * @param value Identity model.
     */
    @JvmName("hwsopxbflwlonmfq")
    public suspend fun resourceAccessIdentity(`value`: IdentityModelArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceAccessIdentity = mapped
    }

    /**
     * @param argument Identity model.
     */
    @JvmName("vrkmghfwekbyobpe")
    public suspend fun resourceAccessIdentity(argument: suspend IdentityModelArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityModelArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resourceAccessIdentity = mapped
    }

    internal fun build(): DraModelPropertiesArgs = DraModelPropertiesArgs(
        authenticationIdentity = authenticationIdentity ?: throw
            PulumiNullFieldException("authenticationIdentity"),
        customProperties = customProperties ?: throw PulumiNullFieldException("customProperties"),
        machineId = machineId ?: throw PulumiNullFieldException("machineId"),
        machineName = machineName ?: throw PulumiNullFieldException("machineName"),
        resourceAccessIdentity = resourceAccessIdentity ?: throw
            PulumiNullFieldException("resourceAccessIdentity"),
    )
}
