@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.inputs

import com.pulumi.azurenative.datareplication.inputs.GetFabricPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fabricName The fabric name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetFabricPlainArgs(
    public val fabricName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.datareplication.inputs.GetFabricPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.datareplication.inputs.GetFabricPlainArgs =
        com.pulumi.azurenative.datareplication.inputs.GetFabricPlainArgs.builder()
            .fabricName(fabricName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFabricPlainArgs].
 */
@PulumiTagMarker
public class GetFabricPlainArgsBuilder internal constructor() {
    private var fabricName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The fabric name.
     */
    @JvmName("jebanrhqnednnekd")
    public suspend fun fabricName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.fabricName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qronrtwlcssqqkgp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetFabricPlainArgs = GetFabricPlainArgs(
        fabricName = fabricName ?: throw PulumiNullFieldException("fabricName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
