@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.inputs

import com.pulumi.azurenative.datareplication.inputs.HyperVToAzStackHCIPolicyModelCustomPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * HyperV To AzStackHCI Policy model custom properties.
 * @property appConsistentFrequencyInMinutes Gets or sets the app consistent snapshot frequency (in minutes).
 * @property crashConsistentFrequencyInMinutes Gets or sets the crash consistent snapshot frequency (in minutes).
 * @property instanceType Gets or sets the instance type.
 * Expected value is 'HyperVToAzStackHCI'.
 * @property recoveryPointHistoryInMinutes Gets or sets the duration in minutes until which the recovery points need to be
 * stored.
 */
public data class HyperVToAzStackHCIPolicyModelCustomPropertiesArgs(
    public val appConsistentFrequencyInMinutes: Output<Int>,
    public val crashConsistentFrequencyInMinutes: Output<Int>,
    public val instanceType: Output<String>,
    public val recoveryPointHistoryInMinutes: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datareplication.inputs.HyperVToAzStackHCIPolicyModelCustomPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.datareplication.inputs.HyperVToAzStackHCIPolicyModelCustomPropertiesArgs =
        com.pulumi.azurenative.datareplication.inputs.HyperVToAzStackHCIPolicyModelCustomPropertiesArgs.builder()
            .appConsistentFrequencyInMinutes(appConsistentFrequencyInMinutes.applyValue({ args0 -> args0 }))
            .crashConsistentFrequencyInMinutes(crashConsistentFrequencyInMinutes.applyValue({ args0 -> args0 }))
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .recoveryPointHistoryInMinutes(recoveryPointHistoryInMinutes.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HyperVToAzStackHCIPolicyModelCustomPropertiesArgs].
 */
@PulumiTagMarker
public class HyperVToAzStackHCIPolicyModelCustomPropertiesArgsBuilder internal constructor() {
    private var appConsistentFrequencyInMinutes: Output<Int>? = null

    private var crashConsistentFrequencyInMinutes: Output<Int>? = null

    private var instanceType: Output<String>? = null

    private var recoveryPointHistoryInMinutes: Output<Int>? = null

    /**
     * @param value Gets or sets the app consistent snapshot frequency (in minutes).
     */
    @JvmName("dodhtupqkqxoambx")
    public suspend fun appConsistentFrequencyInMinutes(`value`: Output<Int>) {
        this.appConsistentFrequencyInMinutes = value
    }

    /**
     * @param value Gets or sets the crash consistent snapshot frequency (in minutes).
     */
    @JvmName("ckslewsavqoqgeeb")
    public suspend fun crashConsistentFrequencyInMinutes(`value`: Output<Int>) {
        this.crashConsistentFrequencyInMinutes = value
    }

    /**
     * @param value Gets or sets the instance type.
     * Expected value is 'HyperVToAzStackHCI'.
     */
    @JvmName("hlhovryfnlwkbcqq")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Gets or sets the duration in minutes until which the recovery points need to be
     * stored.
     */
    @JvmName("dkvcogkmaiergquw")
    public suspend fun recoveryPointHistoryInMinutes(`value`: Output<Int>) {
        this.recoveryPointHistoryInMinutes = value
    }

    /**
     * @param value Gets or sets the app consistent snapshot frequency (in minutes).
     */
    @JvmName("oryprcfxvqudrbpa")
    public suspend fun appConsistentFrequencyInMinutes(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.appConsistentFrequencyInMinutes = mapped
    }

    /**
     * @param value Gets or sets the crash consistent snapshot frequency (in minutes).
     */
    @JvmName("dyxrqladpmwfrwcw")
    public suspend fun crashConsistentFrequencyInMinutes(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.crashConsistentFrequencyInMinutes = mapped
    }

    /**
     * @param value Gets or sets the instance type.
     * Expected value is 'HyperVToAzStackHCI'.
     */
    @JvmName("yxfpljcfsmdryuui")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Gets or sets the duration in minutes until which the recovery points need to be
     * stored.
     */
    @JvmName("vkmfapyiwpjjcbqa")
    public suspend fun recoveryPointHistoryInMinutes(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recoveryPointHistoryInMinutes = mapped
    }

    internal fun build(): HyperVToAzStackHCIPolicyModelCustomPropertiesArgs =
        HyperVToAzStackHCIPolicyModelCustomPropertiesArgs(
            appConsistentFrequencyInMinutes = appConsistentFrequencyInMinutes ?: throw
                PulumiNullFieldException("appConsistentFrequencyInMinutes"),
            crashConsistentFrequencyInMinutes = crashConsistentFrequencyInMinutes ?: throw
                PulumiNullFieldException("crashConsistentFrequencyInMinutes"),
            instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
            recoveryPointHistoryInMinutes = recoveryPointHistoryInMinutes ?: throw
                PulumiNullFieldException("recoveryPointHistoryInMinutes"),
        )
}
