@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.inputs

import com.pulumi.azurenative.datareplication.inputs.PolicyModelPropertiesArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Policy model properties.
 * @property customProperties Policy model custom properties.
 */
public data class PolicyModelPropertiesArgs(
    public val customProperties: Output<Either<HyperVToAzStackHCIPolicyModelCustomPropertiesArgs, VMwareToAzStackHCIPolicyModelCustomPropertiesArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.datareplication.inputs.PolicyModelPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.datareplication.inputs.PolicyModelPropertiesArgs =
        com.pulumi.azurenative.datareplication.inputs.PolicyModelPropertiesArgs.builder()
            .customProperties(
                customProperties.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PolicyModelPropertiesArgs].
 */
@PulumiTagMarker
public class PolicyModelPropertiesArgsBuilder internal constructor() {
    private var customProperties:
        Output<Either<HyperVToAzStackHCIPolicyModelCustomPropertiesArgs, VMwareToAzStackHCIPolicyModelCustomPropertiesArgs>>? =
        null

    /**
     * @param value Policy model custom properties.
     */
    @JvmName("efvdvubhdkdqaxgn")
    public suspend fun customProperties(`value`: Output<Either<HyperVToAzStackHCIPolicyModelCustomPropertiesArgs, VMwareToAzStackHCIPolicyModelCustomPropertiesArgs>>) {
        this.customProperties = value
    }

    /**
     * @param value Policy model custom properties.
     */
    @JvmName("xwhcanstwpwecjlv")
    public suspend fun customProperties(`value`: Either<HyperVToAzStackHCIPolicyModelCustomPropertiesArgs, VMwareToAzStackHCIPolicyModelCustomPropertiesArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customProperties = mapped
    }

    /**
     * @param value Policy model custom properties.
     */
    @JvmName("bjjwkmjvtwgivcep")
    public fun customProperties(`value`: HyperVToAzStackHCIPolicyModelCustomPropertiesArgs) {
        val toBeMapped = Either.ofLeft<
            HyperVToAzStackHCIPolicyModelCustomPropertiesArgs,
            VMwareToAzStackHCIPolicyModelCustomPropertiesArgs,
            >(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customProperties = mapped
    }

    /**
     * @param value Policy model custom properties.
     */
    @JvmName("jedbwppvpflumuxg")
    public fun customProperties(`value`: VMwareToAzStackHCIPolicyModelCustomPropertiesArgs) {
        val toBeMapped = Either.ofRight<
            HyperVToAzStackHCIPolicyModelCustomPropertiesArgs,
            VMwareToAzStackHCIPolicyModelCustomPropertiesArgs,
            >(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customProperties = mapped
    }

    internal fun build(): PolicyModelPropertiesArgs = PolicyModelPropertiesArgs(
        customProperties = customProperties ?: throw PulumiNullFieldException("customProperties"),
    )
}
