@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * AzStackHCI cluster properties.
 * @property clusterName Gets or sets the AzStackHCICluster FQDN name.
 * @property resourceName Gets or sets the AzStackHCICluster resource name.
 * @property storageAccountName Gets or sets the Storage account name.
 * @property storageContainers Gets or sets the list of AzStackHCICluster Storage Container.
 */
public data class AzStackHCIClusterPropertiesResponse(
    public val clusterName: String,
    public val resourceName: String,
    public val storageAccountName: String,
    public val storageContainers: List<StorageContainerPropertiesResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datareplication.outputs.AzStackHCIClusterPropertiesResponse): AzStackHCIClusterPropertiesResponse = AzStackHCIClusterPropertiesResponse(
            clusterName = javaType.clusterName(),
            resourceName = javaType.resourceName(),
            storageAccountName = javaType.storageAccountName(),
            storageContainers = javaType.storageContainers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datareplication.kotlin.outputs.StorageContainerPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
